/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class SessionnameValidator
extends AbstractLogEnabled {
    public static final int MAX_SESSIONNAME_LENGTH = 63;
    private static Logger theLogger = new SessionnameValidator().getLogger();

    private SessionnameValidator() {
    }

    public static void validateSessionName(String sessionname) throws ArgumentException {
        if (sessionname == null) {
            ArgumentException aex = new ArgumentException("a session name must never be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(sessionname)) {
            ArgumentException aex = new ArgumentException("a session name must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!sessionname.matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal session name '" + sessionname + "'");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (sessionname.length() > 63) {
            ArgumentException aex = new ArgumentException("session name '" + sessionname + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

