/*
 * Decompiled with CFR 0.152.
 */
package org.egso.consumer.valid;

import org.apache.log4j.Logger;
import org.egso.common.logging.AbstractLogEnabled;
import org.egso.consumer.api.ArgumentException;

public class UsernameValidator
extends AbstractLogEnabled {
    public static final int MAX_USERNAME_LENGTH = 63;
    private static Logger theLogger = new UsernameValidator().getLogger();

    private UsernameValidator() {
    }

    public static void validateUserName(String username) throws ArgumentException {
        if (username == null) {
            ArgumentException aex = new ArgumentException("a username must never be null");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if ("".equals(username)) {
            ArgumentException aex = new ArgumentException("a username must not be emtpy");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (!username.matches("[a-zA-Z0-9_:/.\\-]*")) {
            ArgumentException aex = new ArgumentException("illegal username '" + username + "'");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
        if (username.length() > 63) {
            ArgumentException aex = new ArgumentException("username '" + username + "' too long " + "(max " + 63 + " characters allowed)");
            if (theLogger.isDebugEnabled()) {
                theLogger.debug((Object)aex);
            }
            throw aex;
        }
    }
}

